/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.gui.service;

import java.io.EOFException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import pro.gravit.launcher.base.Launcher;
import pro.gravit.launcher.base.profiles.ClientProfile;
import pro.gravit.launcher.base.profiles.ClientProfileBuilder;
import pro.gravit.launcher.base.profiles.ClientProfileVersions;
import pro.gravit.launcher.base.profiles.optional.OptionalView;
import pro.gravit.launcher.base.request.auth.SetProfileRequest;
import pro.gravit.launcher.core.hasher.HashedDir;
import pro.gravit.launcher.gui.JavaFXApplication;
import pro.gravit.launcher.gui.config.RuntimeSettings;
import pro.gravit.launcher.gui.impl.AbstractStage;
import pro.gravit.launcher.gui.impl.ContextHelper;
import pro.gravit.launcher.runtime.client.ClientLauncherProcess;
import pro.gravit.launcher.runtime.client.DirBridge;
import pro.gravit.utils.helper.CommonHelper;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.JVMHelper;
import pro.gravit.utils.helper.JavaHelper;
import pro.gravit.utils.helper.LogHelper;

public class LaunchService {
    private final JavaFXApplication application;

    public LaunchService(JavaFXApplication application) {
        this.application = application;
    }

    public boolean isTestUpdate(ClientProfile profile, RuntimeSettings.ProfileSettings settings) {
        return this.application.offlineService.isOfflineMode() || this.application.authService.checkDebugPermission("skipupdate") && settings.debugSkipUpdate;
    }

    private void downloadClients(CompletableFuture<ClientInstance> future, ClientProfile profile, RuntimeSettings.ProfileSettings settings, JavaHelper.JavaVersion javaVersion, HashedDir jvmHDir) {
        Path target = DirBridge.dirUpdates.resolve(profile.getAssetDir());
        LogHelper.info((String)"Start update to %s", (Object[])new Object[]{target.toString()});
        boolean testUpdate = this.isTestUpdate(profile, settings);
        Consumer<HashedDir> next = assetHDir -> {
            Path targetClient = DirBridge.dirUpdates.resolve(profile.getDir());
            LogHelper.info((String)"Start update to %s", (Object[])new Object[]{targetClient.toString()});
            this.application.gui.updateScene.sendUpdateRequest(profile.getDir(), targetClient, profile.getClientUpdateMatcher(), true, this.application.profilesService.getOptionalView(), true, testUpdate, clientHDir -> {
                LogHelper.info((String)"Success update");
                try {
                    ClientInstance instance = this.doLaunchClient(target, (HashedDir)assetHDir, targetClient, (HashedDir)clientHDir, profile, this.application.profilesService.getOptionalView(), javaVersion, jvmHDir);
                    future.complete(instance);
                }
                catch (Throwable e) {
                    future.completeExceptionally(e);
                }
            });
        };
        if (profile.getVersion().compareTo(ClientProfileVersions.MINECRAFT_1_6_4) <= 0) {
            this.application.gui.updateScene.sendUpdateRequest(profile.getAssetDir(), target, profile.getAssetUpdateMatcher(), true, null, false, testUpdate, next);
        } else {
            this.application.gui.updateScene.sendUpdateAssetRequest(profile.getAssetDir(), target, profile.getAssetUpdateMatcher(), true, profile.getAssetIndex(), testUpdate, next);
        }
    }

    private ClientInstance doLaunchClient(Path assetDir, HashedDir assetHDir, Path clientDir, HashedDir clientHDir, ClientProfile profile, OptionalView view, JavaHelper.JavaVersion javaVersion, HashedDir jvmHDir) {
        RuntimeSettings.ProfileSettings profileSettings = this.application.getProfileSettings();
        if (javaVersion == null) {
            javaVersion = this.application.javaService.getRecommendJavaVersion(profile);
        }
        if (javaVersion == null) {
            javaVersion = JavaHelper.JavaVersion.getCurrentJavaVersion();
        }
        if (this.application.authService.checkDebugPermission("skipfilemonitor") && profileSettings.debugSkipFileMonitor) {
            ClientProfileBuilder builder = new ClientProfileBuilder(profile);
            builder.setUpdate(new ArrayList());
            builder.setUpdateVerify(new ArrayList());
            builder.setUpdateExclusions(new ArrayList());
            profile = builder.createClientProfile();
        }
        ClientLauncherProcess clientLauncherProcess = new ClientLauncherProcess(clientDir, assetDir, javaVersion, clientDir.resolve("resourcepacks"), profile, this.application.authService.getPlayerProfile(), view, this.application.authService.getAccessToken(), clientHDir, assetHDir, jvmHDir);
        clientLauncherProcess.params.ram = profileSettings.ram;
        clientLauncherProcess.params.offlineMode = this.application.offlineService.isOfflineMode();
        if (clientLauncherProcess.params.ram > 0) {
            clientLauncherProcess.jvmArgs.add("-Xms" + clientLauncherProcess.params.ram + "M");
            clientLauncherProcess.jvmArgs.add("-Xmx" + clientLauncherProcess.params.ram + "M");
        }
        clientLauncherProcess.params.fullScreen = profileSettings.fullScreen;
        clientLauncherProcess.params.autoEnter = profileSettings.autoEnter;
        if (JVMHelper.OS_TYPE == JVMHelper.OS.LINUX) {
            clientLauncherProcess.params.lwjglGlfwWayland = profileSettings.waylandSupport;
        }
        return new ClientInstance(clientLauncherProcess, profile, profileSettings);
    }

    private String getJavaDirName(Path javaPath) {
        String prefix = DirBridge.dirUpdates.toAbsolutePath().toString();
        if (javaPath == null || !javaPath.startsWith(prefix)) {
            return null;
        }
        Path result = DirBridge.dirUpdates.relativize(javaPath);
        return result.toString();
    }

    private void showJavaAlert(ClientProfile profile) {
        if ((JVMHelper.ARCH_TYPE == JVMHelper.ARCH.ARM32 || JVMHelper.ARCH_TYPE == JVMHelper.ARCH.ARM64) && profile.getVersion().compareTo(ClientProfileVersions.MINECRAFT_1_12_2) <= 0) {
            this.application.messageManager.showDialog(this.application.getTranslation("runtime.scenes.serverinfo.javaalert.lwjgl2.header"), this.application.getTranslation("runtime.scenes.serverinfo.javaalert.lwjgl2.description").formatted(profile.getRecommendJavaVersion()), () -> {}, () -> {}, true);
        } else {
            this.application.messageManager.showDialog(this.application.getTranslation("runtime.scenes.serverinfo.javaalert.header"), this.application.getTranslation("runtime.scenes.serverinfo.javaalert.description").formatted(profile.getRecommendJavaVersion()), () -> {}, () -> {}, true);
        }
    }

    public CompletableFuture<ClientInstance> launchClient() {
        return this.launchClient(this.application.getMainStage());
    }

    private CompletableFuture<ClientInstance> launchClient(AbstractStage stage) {
        ClientProfile profile = this.application.profilesService.getProfile();
        if (profile == null) {
            throw new NullPointerException("profilesService.getProfile() is null");
        }
        CompletableFuture<ClientInstance> future = new CompletableFuture<ClientInstance>();
        this.application.gui.processingOverlay.processRequest(stage, this.application.getTranslation("runtime.overlay.processing.text.setprofile"), new SetProfileRequest(profile), result -> ContextHelper.runInFxThreadStatic(() -> {
            RuntimeSettings.ProfileSettings profileSettings = this.application.getProfileSettings();
            JavaHelper.JavaVersion javaVersion = null;
            for (JavaHelper.JavaVersion v : this.application.javaService.javaVersions) {
                if (!v.jvmDir.toAbsolutePath().toString().equals(profileSettings.javaPath)) continue;
                javaVersion = v;
            }
            if (javaVersion == null && profileSettings.javaPath != null && !this.application.guiModuleConfig.forceDownloadJava) {
                try {
                    javaVersion = JavaHelper.JavaVersion.getByPath((Path)Paths.get(profileSettings.javaPath, new String[0]));
                }
                catch (Throwable e) {
                    if (LogHelper.isDevEnabled()) {
                        LogHelper.error((Throwable)e);
                    }
                    LogHelper.warning((String)"Incorrect java path %s", (Object[])new Object[]{profileSettings.javaPath});
                }
            }
            if (javaVersion == null || this.application.javaService.isIncompatibleJava(javaVersion, profile)) {
                javaVersion = this.application.javaService.getRecommendJavaVersion(profile);
            }
            if (javaVersion == null) {
                this.showJavaAlert(profile);
                return;
            }
            String jvmDirName = this.getJavaDirName(javaVersion.jvmDir);
            if (jvmDirName != null) {
                JavaHelper.JavaVersion finalJavaVersion = javaVersion;
                try {
                    stage.setScene(this.application.gui.updateScene, true);
                    this.application.gui.updateScene.reset();
                }
                catch (Exception e) {
                    future.completeExceptionally(e);
                }
                this.application.gui.updateScene.sendUpdateRequest(jvmDirName, javaVersion.jvmDir, null, true, this.application.profilesService.getOptionalView(), false, this.isTestUpdate(profile, profileSettings), jvmHDir -> {
                    Path javaFile;
                    if ((JVMHelper.OS_TYPE == JVMHelper.OS.LINUX || JVMHelper.OS_TYPE == JVMHelper.OS.MACOSX) && Files.exists(javaFile = finalJavaVersion.jvmDir.resolve("bin").resolve("java"), new LinkOption[0]) && !javaFile.toFile().setExecutable(true)) {
                        LogHelper.warning((String)"Set permission for %s unsuccessful", (Object[])new Object[]{javaFile.toString()});
                    }
                    this.downloadClients(future, profile, profileSettings, finalJavaVersion, (HashedDir)jvmHDir);
                });
            } else {
                try {
                    stage.setScene(this.application.gui.updateScene, true);
                    this.application.gui.updateScene.reset();
                }
                catch (Exception e) {
                    future.completeExceptionally(e);
                }
                this.downloadClients(future, profile, profileSettings, javaVersion, null);
            }
        }), future::completeExceptionally, (EventHandler<ActionEvent>)null);
        return future;
    }

    public class ClientInstance {
        private final ClientLauncherProcess process;
        private final ClientProfile clientProfile;
        private final RuntimeSettings.ProfileSettings settings;
        private final Thread writeParamsThread;
        private Thread runThread;
        private final CompletableFuture<Void> onWriteParams = new CompletableFuture();
        private final CompletableFuture<Integer> runFuture = new CompletableFuture();
        private final Set<ProcessListener> listeners = ConcurrentHashMap.newKeySet();

        public ClientInstance(ClientLauncherProcess process, ClientProfile clientProfile, RuntimeSettings.ProfileSettings settings) {
            this.process = process;
            this.clientProfile = clientProfile;
            this.settings = settings;
            this.writeParamsThread = CommonHelper.newThread((String)"Client Params Writer Thread", (boolean)true, () -> {
                try {
                    process.runWriteParams((SocketAddress)new InetSocketAddress("127.0.0.1", Launcher.getConfig().clientPort));
                    this.onWriteParams.complete(null);
                }
                catch (Throwable e) {
                    LogHelper.error((Throwable)e);
                    this.onWriteParams.completeExceptionally(e);
                }
            });
        }

        private void run() {
            try {
                this.process.start(true);
                Process proc = this.process.getProcess();
                InputStream stream = proc.getInputStream();
                byte[] buf = IOHelper.newBuffer();
                try {
                    int length = stream.read(buf);
                    while (length >= 0) {
                        this.handleListeners(buf, 0, length);
                        length = stream.read(buf);
                    }
                }
                catch (EOFException eOFException) {
                    // empty catch block
                }
                if (proc.isAlive()) {
                    proc.waitFor();
                }
                if (this.writeParamsThread != null && this.writeParamsThread.isAlive()) {
                    this.writeParamsThread.interrupt();
                }
                this.runFuture.complete(proc.exitValue());
            }
            catch (Throwable e) {
                if (this.writeParamsThread != null && this.writeParamsThread.isAlive()) {
                    this.writeParamsThread.interrupt();
                }
                this.runFuture.completeExceptionally(e);
            }
        }

        public void kill() {
            this.process.getProcess().destroyForcibly();
        }

        private void handleListeners(byte[] buf, int offset, int length) {
            for (ProcessListener l : this.listeners) {
                l.onNext(buf, offset, length);
            }
        }

        public synchronized CompletableFuture<Integer> start() {
            if (this.runThread == null) {
                this.runThread = CommonHelper.newThread((String)"Run Thread", (boolean)true, this::run);
                this.writeParamsThread.start();
                this.runThread.start();
            }
            return this.runFuture;
        }

        public ClientLauncherProcess getProcess() {
            return this.process;
        }

        public ClientProfile getClientProfile() {
            return this.clientProfile;
        }

        public RuntimeSettings.ProfileSettings getSettings() {
            return this.settings;
        }

        public CompletableFuture<Void> getOnWriteParamsFuture() {
            return this.onWriteParams;
        }

        public void registerListener(ProcessListener listener) {
            this.listeners.add(listener);
        }

        public void unregisterListener(ProcessListener listener) {
            this.listeners.remove(listener);
        }

        @FunctionalInterface
        public static interface ProcessListener {
            public void onNext(byte[] var1, int var2, int var3);
        }
    }
}

